//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2017 BY HOLTEK SEMICONDUCTOR INC
//  File Name : Blood_Pressure.h
// Description: Blood_Pressure
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 2017/12/20
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________


#ifndef _Blood_Pressure_H_
#define _Blood_Pressure_H_


/********************************************************************
Function:	Function
********************************************************************/
//设置舒张压收缩压的比例系数
#define	LU8C_KD					67//58
#define	LU8C_KS					52//78

//設置心率偵測的 buff 大小，越大越嚴苛
#define	Lu8c_buff_lenght		5

//設置 最大加壓壓力
#define	LU8C_MAX_PRESSURE		290

//默认加压压力
#define	LU8C_DEFAULT_PRESSURE	220

//設置未接袖帶檢測時間 N s內沒有檢測到壓力大於30mmhg判斷為沒有接袖帶
#define	LU8C_NO_Load_TIME		15		//1 is 0.5s

//設置充氣最長時間 N s內沒有檢測到壓力大於30mmhg判斷為沒有接袖帶
#define	LU8C_MAX_PUMP_TIME		80		//1 is 0.5s

#define	LU8C_MAX_MEASURE_TIME	240		//1 is 0.5s

//波形識別閾值 最小斜率
#define	LU8C_MIN_SLOPE			15


//设置充气速度
#define	LU8C_MAX_PUMP_SPEED		15

/********************************************************************
Function:	Function
********************************************************************/
//每次開始測量時需要設置初始化
void	fun_Bloop_Pressure_init(u8	lu8v_target_pressure);
//智能加壓判斷
void	BP_IntelliSense_pressure(u16	lu8c_current_pressure,u8	lu8c_heart_wave);
//降壓測量血壓
void	BP_pressure_analyze(u16	lu8c_current_pressure,u8	lu8c_heart_wave);
/********************************************************************
Function:	volatile
********************************************************************/				
extern	u16		gu16v_dia		;			
extern	u16		gu16v_sys	;			
extern	u8		gu8v_heart	;				

extern	u16		gu16v_peak_pressure_target;	
extern	u16		gu16v_peak_pressure_target_last;
//設置心率偵測的 buff 大小，越大越嚴苛
extern	u8		gu8a_heart_wave_buff[Lu8c_buff_lenght];	
extern	u8		gu8v_kd;
extern	u8		gu8v_ks;
extern	u8		gu8v_cal_err_code;
extern	__16_type	gu8v_blood_flag;

extern	u8		gu8a_peak_wave_guide;
extern	u16		gu16v_avg	;	

static volatile u8		gu16a_peak_pressure[64]				__attribute__ ((at(0x280)));   
static volatile u8		gu8a_heart_time[64]					__attribute__ ((at(0x380)));   
static volatile u8		gu8a_peak_wave[64]					__attribute__ ((at(0x3c0)));  

////
#define	gbv_heart				gu8v_blood_flag.bits.b0
#define	gbv_stop_value			gu8v_blood_flag.bits.b9
#define	gbv_arrhythmia			gu8v_blood_flag.bits.b15

#endif

